﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KursBeispiele
{
    public partial class Form1 : Form
    {
        //Kein Modifizierer daher private
        delegate double calculate(double x, double y);

        //Anlegen einer globalen Variable
        calculate berechnung;

        public Form1()
        {
            InitializeComponent();

            //Wird gesetzt nachdem EventHandler gesetzt wurde
            //d.h. comboBox1_SelectedIndexChanged wird sofort aufgerufen
            comboBox1.SelectedIndex = 0;

            //Dies ist notwendig da die globale Variable ansonsten nicht instanziiert wurde!
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            //Verwendung einer Switch-Case Anweisung
            switch (comboBox1.SelectedItem.ToString())
            {
                case "*":
                    berechnung = new calculate(Functions.multiply);
                    break;
                case "%":
                    berechnung = new calculate(Functions.mod);
                    break;
                case "^":
                    berechnung = new calculate(Functions.pow);
                    break;
                case "/":
                    berechnung = new calculate(Functions.divide);
                    break;
                case "-":
                    berechnung = new calculate(Functions.subtract);
                    break;
                case "+":
                default:
                    berechnung = new calculate(Functions.add);
                    break;
            }

            //Jetzt ist die globale Variable instanziiert mit einer neuen Delgaten-Instanz
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //Wir könnten die decimals auch casten aber
            //eine gute Alternative ist das (sichere) Verwenden von
            //der Convert Klasse - hier mit ToDouble()
            double x = Convert.ToDouble(numericUpDown1.Value);
            double y = Convert.ToDouble(numericUpDown2.Value);

            //Um die Funktion hinter dem Delegaten auszuführen wird die Methode Invoke aufgerufen
            double z = berechnung.Invoke(x, y);

            MessageBox.Show("Das Ergebnis ist " + z);
        }
    }

    public static class Functions
    {
        public static double add(double x, double y)
        {
            return x + y;
        }

        public static double subtract(double x, double y)
        {
            return x - y;
        }

        public static double multiply(double x, double y)
        {
            return x * y;
        }

        public static double divide(double x, double y)
        {
            return x / y;
        }

        public static double mod(double x, double y)
        {
            return x % y;
        }

        public static double pow(double x, double y)
        {
            return Math.Pow(x, y);
        }
    }
}
